// Smooth scroll para links internos
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
            target.scrollIntoView({
                behavior: 'smooth',
                block: 'start'
            });
        }
    });
});

// Animação de entrada dos elementos ao scroll
const observerOptions = {
    threshold: 0.1,
    rootMargin: '0px 0px -50px 0px'
};

const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
        if (entry.isIntersecting) {
            entry.target.style.opacity = '1';
            entry.target.style.transform = 'translateY(0)';
        }
    });
}, observerOptions);

// Observar cards e seções
document.querySelectorAll('.benefit-card, .review-card, .about-content').forEach(el => {
    el.style.opacity = '0';
    el.style.transform = 'translateY(30px)';
    el.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
    observer.observe(el);
});

// Rastreamento de cliques nos botões WhatsApp
const whatsappButtons = document.querySelectorAll('a[href*="wa.me"]');
whatsappButtons.forEach(button => {
    button.addEventListener('click', function() {
        console.log('Botão WhatsApp clicado');
        // Aqui você pode adicionar tracking do Google Analytics, Facebook Pixel, etc.
        // Exemplo: gtag('event', 'click', { 'event_category': 'WhatsApp', 'event_label': 'Grupo VIP' });
    });
});

// Parallax suave no hero
window.addEventListener('scroll', () => {
    const scrolled = window.pageYOffset;
    const hero = document.querySelector('.hero');
    if (hero && scrolled < window.innerHeight) {
        hero.style.backgroundPositionY = scrolled * 0.5 + 'px';
    }
});

// Animação de números (trust badges)
const animateNumbers = () => {
    const trustNumbers = document.querySelectorAll('.trust-number');
    
    trustNumbers.forEach(element => {
        const target = element.textContent;
        const isDecimal = target.includes('.');
        const numericValue = parseFloat(target.replace(/[^\d.]/g, ''));
        const suffix = target.replace(/[\d.]/g, '');
        
        let current = 0;
        const increment = numericValue / 50;
        const timer = setInterval(() => {
            current += increment;
            if (current >= numericValue) {
                element.textContent = target;
                clearInterval(timer);
            } else {
                if (isDecimal) {
                    element.textContent = current.toFixed(1) + suffix;
                } else {
                    element.textContent = Math.floor(current) + suffix;
                }
            }
        }, 30);
    });
};

// Observar a seção de trust badges
const trustSection = document.querySelector('.trust-badges');
if (trustSection) {
    const trustObserver = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                animateNumbers();
                trustObserver.unobserve(entry.target);
            }
        });
    }, { threshold: 0.5 });
    
    trustObserver.observe(trustSection);
}

// Sistema de Notificações de Entrada no Grupo
const nomes = [
    'Carlos Silva', 'Ana Paula', 'Ricardo Santos', 'Juliana Costa', 'Fernando Oliveira',
    'Mariana Souza', 'Lucas Almeida', 'Beatriz Lima', 'Rafael Pereira', 'Camila Rodrigues',
    'Diego Martins', 'Larissa Fernandes', 'Thiago Barbosa', 'Amanda Carvalho', 'Bruno Ribeiro',
    'Gabriela Mendes', 'Rodrigo Araújo', 'Patrícia Gomes', 'Vinícius Dias', 'Renata Castro',
    'Marcelo Rocha', 'Fernanda Cardoso', 'André Monteiro', 'Vanessa Correia', 'Paulo Teixeira',
    'Carolina Pinto', 'Gustavo Moreira', 'Isabela Nunes', 'Felipe Barros', 'Letícia Freitas'
];

const cidades = [
    'São Paulo, SP', 'Rio de Janeiro, RJ', 'Belo Horizonte, MG', 'Curitiba, PR', 
    'Porto Alegre, RS', 'Brasília, DF', 'Salvador, BA', 'Fortaleza, CE',
    'Recife, PE', 'Manaus, AM', 'Goiânia, GO', 'Campinas, SP', 'Florianópolis, SC',
    'Vitória, ES', 'Santos, SP', 'Niterói, RJ', 'Ribeirão Preto, SP', 'Sorocaba, SP'
];

const mensagens = [
    'acabou de entrar no Grupo VIP! 🎉',
    'garantiu a vaga VIP! Seja bem-vindo! 👏',
    'entrou no grupo e já garantiu acesso antecipado! ⚡',
    'está no Grupo VIP agora! Bem-vindo! 🔥',
    'acabou de se juntar ao Grupo VIP! 🎊'
];

let notificationQueue = [];
let isShowingNotification = false;

function createNotification(nome, cidade, mensagem) {
    const container = document.getElementById('notifications-container');
    
    const notification = document.createElement('div');
    notification.className = 'notification';
    
    notification.innerHTML = `
        <div class="notification-icon">
            <svg viewBox="0 0 24 24" fill="currentColor">
                <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
            </svg>
        </div>
        <div class="notification-content">
            <div class="notification-name">${nome}</div>
            <div class="notification-message">${mensagem}</div>
            <div class="notification-time">📍 ${cidade} • Agora mesmo</div>
        </div>
    `;
    
    container.appendChild(notification);
    
    // Remove após 5 segundos
    setTimeout(() => {
        notification.remove();
        isShowingNotification = false;
        showNextNotification();
    }, 5000);
}

function showNextNotification() {
    if (notificationQueue.length > 0 && !isShowingNotification) {
        isShowingNotification = true;
        const next = notificationQueue.shift();
        createNotification(next.nome, next.cidade, next.mensagem);
    }
}

function generateRandomNotification() {
    const nome = nomes[Math.floor(Math.random() * nomes.length)];
    const cidade = cidades[Math.floor(Math.random() * cidades.length)];
    const mensagem = mensagens[Math.floor(Math.random() * mensagens.length)];
    
    notificationQueue.push({ nome, cidade, mensagem });
    showNextNotification();
}

// Iniciar notificações após 3 segundos
setTimeout(() => {
    generateRandomNotification();
    
    // Gerar nova notificação a cada 8-15 segundos
    setInterval(() => {
        const randomDelay = Math.floor(Math.random() * 7000) + 8000; // 8-15 segundos
        setTimeout(generateRandomNotification, randomDelay);
    }, 15000);
}, 3000);

// Log de página carregada
console.log('🔥 Black Friday VIP 2025 - 3FS Imports');
console.log('Landing Page carregada com sucesso!');
