# Landing Page Black Friday VIP - 3FS Imports

Landing page desenvolvida para capturar leads para o grupo VIP da Black Friday 2025 da 3FS Imports.

## 🎯 Objetivo

Criar urgência e exclusividade para atrair clientes para um grupo VIP com acesso antecipado às ofertas da Black Friday.

## 🚀 Estrutura

- **Hero Section**: Chamada principal com botão WhatsApp VIP destacado
- **Benefícios**: 4 cards explicando as vantagens do grupo VIP (layout 2x2)
- **Prova Social**: Seção com imagens de pedidos e volume de envios
- **Quem Somos**: Apresentação da empresa com galeria de produtos
- **Avaliações**: Depoimentos de clientes e badges de confiança (layout 2x2)
- **CTA Final**: Botão direto para WhatsApp sem formulário
- **Rodapé**: Informações da empresa e contato

## 🎨 Cores

- Preto: `#000000`
- Amarelo: `#F1C40E`
- Cinza escuro: `#1a1a1a`

## ⚙️ Personalizações Necessárias

### 1. WhatsApp
No arquivo `index.html`, atualize o número do WhatsApp em todos os botões:
- Linha 29 (Hero)
- Linha 95 (Benefícios)
- Linha 280 (CTA Final)

Substitua `5521999999999` pelo número real da 3FS Imports (com código do país e DDD).

Exemplo:
```html
href="https://wa.me/5521999999999?text=..."
```

### 2. Contatos no Rodapé
No arquivo `index.html`, seção footer, atualize:
- E-mail de contato
- Número de WhatsApp
- Links das redes sociais (Instagram e Facebook)

### 3. Google Analytics / Facebook Pixel (Opcional)
Adicione seus códigos de rastreamento no `<head>` do `index.html` antes do fechamento da tag.

### 4. Avaliações
Personalize os depoimentos na seção de avaliações com clientes reais se desejar.

## 📱 Responsividade

A landing page é **totalmente otimizada para mobile** e funciona perfeitamente em:
- **Mobile**: 320px - 480px (fontes e botões ajustados)
- **Tablet**: 481px - 768px (layout adaptado)
- **Desktop**: 769px - 1024px (2 colunas)
- **Large Desktop**: 1025px+ (layout completo)

### Otimizações Mobile:
- ✅ Fontes reduzidas proporcionalmente
- ✅ Botões com tamanho adequado para toque
- ✅ Espaçamentos otimizados
- ✅ Cards empilhados verticalmente
- ✅ Imagens responsivas
- ✅ Logo ajustada por breakpoint

## 🌐 Como Usar

1. Certifique-se de que todos os arquivos estão na pasta correta
2. As imagens devem estar em `/imagens/`
3. **Atualize o número do WhatsApp** nos 3 botões do `index.html`
4. Abra o arquivo `index.html` no navegador ou acesse via servidor local (XAMPP)
5. Teste em diferentes dispositivos (desktop, tablet, mobile)

## 📂 Estrutura de Arquivos

```
black-3fs/
├── index.html          # Página principal
├── style.css           # Estilos
├── script.js           # Funcionalidades JavaScript
├── README.md           # Este arquivo
└── imagens/            # Pasta com imagens
    ├── logomarca-branca.webp
    ├── produto.jpeg
    ├── produto-camisa.jpeg
    ├── produto2.jpeg
    ├── produtocamiseta.jpeg
    └── produtooculos-modelo-rosto.jpeg
```

## ✨ Funcionalidades

- ✅ **Notificações em tempo real** - Pessoas entrando no grupo VIP com animações
- ✅ **Botões WhatsApp chamativos** com gradiente verde e ícone
- ✅ **Efeitos de brilho** e animações pulsantes nos CTAs
- ✅ **Seção de prova social** com imagens de pedidos reais
- ✅ **Layout sofisticado** com gradientes sutis e sombras elegantes
- ✅ **Cards em números pares** (2x2) para melhor harmonia visual
- ✅ **Totalmente otimizado para mobile** com fontes e botões ajustados
- ✅ **Conversão direta** - sem formulário, clique direto no WhatsApp
- ✅ **Sistema de urgência social** - Mostra pessoas reais entrando no grupo
- ✅ Animações suaves ao scroll
- ✅ Efeito parallax no hero
- ✅ Animação de números nos badges de confiança
- ✅ Smooth scroll entre seções
- ✅ 3 pontos de conversão estratégicos
- ✅ Design premium e profissional
- ✅ Performance otimizada

### 🔔 Sistema de Notificações
- Notificações aparecem automaticamente mostrando pessoas entrando no grupo
- 30 nomes brasileiros diferentes
- 18 cidades do Brasil
- 5 mensagens variadas de boas-vindas
- Animação de entrada suave pela esquerda
- Efeito shimmer (brilho) durante exibição
- Desaparece automaticamente após 5 segundos
- Totalmente responsivo para mobile

## 🔧 Tecnologias

- HTML5
- CSS3 (Grid, Flexbox, Animations)
- JavaScript Vanilla (ES6+)
- Google Fonts (Montserrat)

## 📊 Otimizações SEO

- Meta tags configuradas
- Títulos semânticos (H1, H2, H3)
- Alt text nas imagens
- Estrutura HTML semântica
- Performance otimizada

## 🎯 Próximos Passos

1. Configurar o número do WhatsApp
2. Atualizar informações de contato
3. Testar em diferentes dispositivos
4. Adicionar Google Analytics (opcional)
5. Configurar domínio personalizado
6. Criar campanhas de tráfego pago

## 📞 Suporte

Para dúvidas ou personalizações adicionais, entre em contato.

---

**Desenvolvido para 3FS Imports - Black Friday 2024**
